<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
	<xsl:output method="html" encoding="utf-8" media-type="text/xml" />
	
	<!-- パラメータ取得&変数に代入(index.htmlの/Rootのlang属性値 -->
	<!-- この変数はテンプレ中どこからでも$_langとして参照できる -->
	<xsl:param name="_lang"  select="/Root/@lang" />
	<xsl:param name="_tax"  select="1.05" />
	
	<!-- 最初に動くテンプレート -->
	<xsl:template match="/Root">
	<xsl:variable name="root" select="document(DataFile)"/>
		<xsl:apply-templates select="$root/*">
			<xsl:with-param name="lang"><xsl:value-of select="@lang"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<!-- データファイルの整形 -->
	<xsl:template match="/Data">
		<html>
			<head>
				<title><xsl:value-of select="Title/*[local-name()=$_lang]"/></title>
				<style type="text/css">
					table {
						border :1px solid #99efef;
						background-color : #888888;
					}
					th{
						background-color : white;
						padding : 10 0 10 3;
					}
					th,td{
						border :1px dotted grya;
						background-color : white;
					} 
				</style>
			</head>
			<body>
				<xsl:apply-templates select="Items">
					<xsl:with-param name="lang_local"><xsl:value-of select="$_lang"/></xsl:with-param>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
	<!-- Listノードの処理 -->
	<xsl:template match="Items">
		<xsl:param name="lang_local" />
		<table>
			<thead>
				<tr>
					<xsl:if test="$lang_local='ja'"><!-- 日本語のヘッダ -->
						<th>ISBN</th><th>なまえ</th><th>出版社</th><th>著者等</th><th>金額(税抜)</th>
					</xsl:if>
					<xsl:if test="$_lang='en'"><!-- 英語のヘッダ -->
						<th>ISBN</th><th>Name</th><th>Publisher</th><th>Auther</th><th>Price</th>
					</xsl:if>
				</tr>
			</thead>
			<tbody >
				<xsl:for-each select="Book">
				 <xsl:sort select="./@price" data-type="number" order="ascending"/><!-- IDでソート -->
					<!-- Divタグ作成 idに"user_+id属性値 -->
					<xsl:element name="div">
						<xsl:attribute name="id"><xsl:value-of select="concat('user_', @id)"/></xsl:attribute>
							<xsl:call-template name="write_row" /> <!--下のwrite_userテンプレートを呼ぶ -->
					</xsl:element>
				</xsl:for-each>
				<tr>
					<td colspan="4" style="text-align:right;">
						<xsl:if test="$_lang='ja'">合計金額</xsl:if>
						<xsl:if test="$_lang='en'">Summary</xsl:if>
					</td>
					<td><xsl:value-of select="format-number(sum(Book/@price),'#,##0')"/></td>
				</tr>
			</tbody>
		</table>
	</xsl:template>
	
	<!-- 64行目から呼ばれるテンプレート -->
	<xsl:template name="write_row">
		<tr>
			<td>
				<xsl:value-of select="./ISBN"/>
			</td>
			<td>
				<xsl:value-of select="./Name"/>
			</td>
			<td>
				<xsl:value-of select="./Publisher/*[local-name()=$_lang]"/>
			</td>
			<td>
				<xsl:value-of select="Author"/>
			<xsl:if test="Creator!=''">
				,  <xsl:value-of select="Creator"/>(<xsl:value-of select="Creator/@Role"/>)
			</xsl:if>
			</td>
			<td style="text-align:right;">
				<xsl:value-of select="format-number($_tax * @price,'#,##0')"/>
				(<xsl:value-of select="format-number( @price,'#,##0')"/>)
			</td>
		</tr>
		
	</xsl:template>
</xsl:stylesheet>
